<?php
require_once '../config/db.php';

$start_date = $_GET['start_date'] ?? '';
$end_date = $_GET['end_date'] ?? '';
$product_name = $_GET['product_name'] ?? '';

$where = [];
$params = [];
if ($start_date) {
    $where[] = 'DATE(sa.adjusted_at) >= ?';
    $params[] = $start_date;
}
if ($end_date) {
    $where[] = 'DATE(sa.adjusted_at) <= ?';
    $params[] = $end_date;
}
if ($product_name) {
    $where[] = 'p.name LIKE ?';
    $params[] = "%$product_name%";
}
$where_sql = $where ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT sa.*, p.name as product_name, u.username as adjusted_by_name
        FROM stock_adjustments sa
        JOIN products p ON sa.product_id = p.id
        JOIN users u ON sa.adjusted_by = u.id
        $where_sql
        ORDER BY sa.adjusted_at DESC
        LIMIT 20";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$adjustments = $stmt->fetchAll();

foreach ($adjustments as $adj): ?>
<tr>
  <td><?php echo date('Y-m-d H:i', strtotime($adj['adjusted_at'])); ?></td>
  <td><?php echo htmlspecialchars($adj['product_name']); ?></td>
  <td>
    <?php if ($adj['quantity'] > 0): ?>
      <span class="badge bg-success">+<?php echo $adj['quantity']; ?></span>
    <?php elseif ($adj['quantity'] < 0): ?>
      <span class="badge bg-danger"><?php echo $adj['quantity']; ?></span>
    <?php else: ?>
      <span class="badge bg-secondary">0</span>
    <?php endif; ?>
  </td>
  <td><?php echo htmlspecialchars($adj['reason']); ?></td>
  <td><?php echo htmlspecialchars($adj['adjusted_by_name']); ?></td>
</tr>
<?php endforeach; ?> 